package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.annotations.CreationTimestamp;

/**
 * The Class CommentHistory.
 * 
 * Description: In this CommentHistory Class implements the interface
 * Serializable and defines the entity and data mapping for the
 * dbo.User_Approver Table in the database.
 */
@Entity
@Table(name = "CommentHistory", schema = "dbo")
public class CommentHistory implements Serializable {
	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -1794346067929332768L;
	
	/** The comment id. */
	@Id
	@Column(name = "CommentId", unique = true, nullable = false)
	private int commentId;
	
	/** The request id. */
	@Transient
	private int requestId;
	
	/** The request. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "RequestId", nullable = false)
	private Request request;
	
	/** The workflow status. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "StatusId", nullable = false)
	private WorkflowStatus workflowStatus;
	
	/** The comments. */
	@Column(name = "Comments", length = 3000)
	private String comments;
	
	/** The created on. */
	@CreationTimestamp
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	private Date createdOn;
	
	/** The created by. */
	@Column(name = "CreatedBy", length = 50)
	private String createdBy;
	
	/** The status. */
	@Transient
	private String status;
	
	/** The type. */
	@Column(name = "Type", length = 6)
	private String type;
	
	/** The task id. */
	@Column(name = "TaskId", length = 50)
	private String taskId;

	/** The Comment Type id. */
	@Column(name = "CommentTypeId", nullable = false, insertable = false, updatable = false)
	private Integer commentTypeId;

	/** The workflow status. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "CommentTypeId", nullable = false)
	private CommentType commentType;

	/**
	 * Gets the comment id.
	 *
	 * @return the comment id
	 */
	public int getCommentId() {
		return this.commentId;
	}

	/**
	 * Sets the comment id.
	 *
	 * @param commentId
	 *            the new comment id
	 */
	public void setCommentId(int commentId) {
		this.commentId = commentId;
	}

	/**
	 * Gets the request.
	 *
	 * @return the request
	 */
	public Request getRequest() {
		return this.request;
	}

	/**
	 * Sets the request.
	 *
	 * @param request
	 *            the new request
	 */
	public void setRequest(Request request) {
		this.request = request;
	}

	/**
	 * Gets the workflow status.
	 *
	 * @return the workflow status
	 */
	public WorkflowStatus getWorkflowStatus() {
		return this.workflowStatus;
	}

	/**
	 * Sets the workflow status.
	 *
	 * @param workflowStatus
	 *            the new workflow status
	 */
	public void setWorkflowStatus(WorkflowStatus workflowStatus) {
		this.workflowStatus = workflowStatus;
	}

	/**
	 * Gets the comments.
	 *
	 * @return the comments
	 */
	public String getComments() {
		return this.comments;
	}

	/**
	 * Sets the comments.
	 *
	 * @param comment
	 *            the new comments
	 */
	public void setComments(String comment) {
		this.comments = comment;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn
	 *            the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy
	 *            the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the request id.
	 *
	 * @return the request id
	 */
	public int getRequestId() {
		return requestId;
	}

	/**
	 * Sets the request id.
	 *
	 * @param requestId
	 *            the new request id
	 */
	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	public CommentType getCommentType() {
		return this.commentType;
	}

	public void setCommentType(CommentType commentType) {
		this.commentType = commentType;
	}

	/**
	 * Sets the status.
	 *
	 * @param status
	 *            the new status
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Sets the type.
	 *
	 * @param type
	 *            the new type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Gets the task id.
	 *
	 * @return the task id
	 */
	public String getTaskId() {
		return this.taskId;
	}

	/**
	 * Sets the task id.
	 *
	 * @param taskId
	 *            the new task id
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public Integer getCommentTypeId() {
		return this.commentTypeId;
	}

	public void setCommentTypeId(Integer commentTypeId) {
		this.commentTypeId = commentTypeId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CommentHistory [commentId=" + commentId + ", request=" + request + ", workflowStatus=" + workflowStatus + ", comments=" + comments + ", createdOn=" + createdOn + ", createdBy=" + createdBy + ", requestId=" + requestId + ", status=" + status + ", type=" + type + ", taskId=" + taskId + ",  commenttypeId=" + commentTypeId + "]";
	}
}
